#!/usr/bin/env python
import os
import sys
import argparse
import subprocess

def main():
    """启动AI炸弹人游戏"""
    parser = argparse.ArgumentParser(description="启动AI炸弹人游戏")
    parser.add_argument("--config", type=str, default="model_config_example.json", 
                      help="模型配置文件路径，默认为model_config_example.json")
    parser.add_argument("--episodes", type=int, default=3, help="游戏局数，默认为3")
    parser.add_argument("--steps", type=int, default=300, help="每局最大步数，默认为300")
    parser.add_argument("--delay", type=float, default=0.5, help="每步延迟时间(秒)，默认为0.5")
    parser.add_argument("--difficulty", type=str, choices=['easy', 'normal'], 
                       default='easy', help="游戏难度: easy, normal")

    args = parser.parse_args()
    
    # 检查文件是否存在
    script_dir = os.path.dirname(os.path.abspath(__file__))
    config_path = os.path.join(script_dir, args.config)
    multi_model_game_path = os.path.join(script_dir, "multi_model_game.py")
    
    if not os.path.exists(config_path):
        print(f"错误: 配置文件 {config_path} 不存在")
        return
        
    if not os.path.exists(multi_model_game_path):
        print(f"错误: 未找到multi_model_game.py。请确保已创建该文件。")
        return
    
    # 构建命令
    cmd = [
        sys.executable,
        multi_model_game_path,
        "--config", config_path,
        "--episodes", str(args.episodes),
        "--steps", str(args.steps),
        "--delay", str(args.delay),
        "--difficulty", args.difficulty
    ]
    
    print("启动AI炸弹人游戏...")
    print(f"配置文件: {config_path}")
    print(f"难度: {args.difficulty}")
    print(f"局数: {args.episodes}")
    print(f"每局最大步数: {args.steps}")
    print(f"每步延迟: {args.delay}秒")
    
    try:
        subprocess.run(cmd)
    except KeyboardInterrupt:
        print("\n游戏已中断")
    except Exception as e:
        print(f"运行时出错: {e}")

if __name__ == "__main__":
    main()
